/*
 * Decompiled with CFR 0.152.
 */
package jemu.util.ass;

import java.util.Stack;
import jemu.util.ass.Z80Assembler;

public class MathParser {
    private static double result;
    public static boolean precision;
    public static boolean DEG;
    public static boolean RAD;

    public MathParser(String expression) throws Exception {
        expression = MathParser.analyseExpressionForSymbols(expression);
        result = MathParser.calculatePostFix(MathParser.generatePostFix(expression));
    }

    public static String Format(String in) {
        if (in.contains(" AND ")) {
            in = in.replace(" AND ", " | ");
        }
        if (in.contains(" OR ")) {
            in = in.replace(" OR ", " \u00a1 ");
        }
        if (in.contains(" XOR ")) {
            in = in.replace(" XOR ", " ! ");
        }
        if (in.contains(" and ")) {
            in = in.replace(" and ", " | ");
        }
        if (in.contains(" or ")) {
            in = in.replace(" or ", " \u00a1 ");
        }
        if (in.contains(" xor ")) {
            in = in.replace(" xor ", " ! ");
        }
        in = in.replace(" ", "");
        return in;
    }

    public static String parseMath(String expression) {
        String out = expression;
        expression = MathParser.Format(expression);
        try {
            DEG = false;
            RAD = true;
            expression = expression.replace("\u00b2", "^2");
            expression = expression.replace("\u00b3", "^3");
            if (expression.startsWith("deg:")) {
                DEG = true;
                RAD = false;
                expression = expression.substring(4);
            }
            if (expression.startsWith("rad:")) {
                DEG = false;
                RAD = true;
                expression = expression.substring(4);
            }
            if (expression.startsWith("grad:")) {
                DEG = false;
                RAD = false;
                expression = expression.substring(5);
            }
            expression = MathParser.analyseExpressionForSymbols(expression);
            result = MathParser.calculatePostFix(MathParser.generatePostFix(expression));
            return "" + (int)result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String parseMaths(String expression) {
        expression = MathParser.Format(expression);
        try {
            DEG = false;
            RAD = true;
            expression = expression.replace("\u00b2", "^2");
            expression = expression.replace("\u00b3", "^3");
            if (expression.startsWith("deg:")) {
                DEG = true;
                RAD = false;
                expression = expression.substring(4);
            }
            if (expression.startsWith("rad:")) {
                DEG = false;
                RAD = true;
                expression = expression.substring(4);
            }
            if (expression.startsWith("grad:")) {
                DEG = false;
                RAD = false;
                expression = expression.substring(5);
            }
            boolean prec = precision;
            precision = true;
            expression = MathParser.analyseExpressionForSymbols(expression);
            result = MathParser.calculatePostFix(MathParser.generatePostFix(expression));
            precision = prec;
            return "" + result;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String parseMath(String expression, boolean preci, boolean hex) {
        expression = MathParser.Format(expression);
        try {
            DEG = false;
            RAD = true;
            expression = expression.replace("\u00b2", "^2");
            expression = expression.replace("\u00b3", "^3");
            if (expression.startsWith("deg:")) {
                DEG = true;
                RAD = false;
                expression = expression.substring(4);
            }
            if (expression.startsWith("rad:")) {
                DEG = false;
                RAD = true;
                expression = expression.substring(4);
            }
            if (expression.startsWith("grad:")) {
                DEG = false;
                RAD = false;
                expression = expression.substring(5);
            }
            boolean prec = precision;
            precision = preci;
            expression = MathParser.analyseExpressionForSymbols(expression);
            result = MathParser.calculatePostFix(MathParser.generatePostFix(expression));
            precision = prec;
            if (hex) {
                return "" + (int)result;
            }
            return "" + result;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String analyseExpressionForSymbols(String expression) throws Exception {
        expression = MathParser.Format(expression);
        expression = "(" + expression + ")";
        if (MathParser.findAdequateBracketEnd(expression, 0) == -1) {
            throw new Exception("Brackets are set wrongly");
        }
        expression = MathParser.transformMinus(expression);
        expression = MathParser.transformSqrt(expression);
        expression = MathParser.transformExp(expression);
        expression = MathParser.transformPi(expression);
        expression = MathParser.transformSqr(expression);
        expression = MathParser.transformTrigo(expression, "");
        return expression;
    }

    private static int findAdequateBracketEnd(String expression, int start) {
        expression = MathParser.Format(expression);
        int count = 0;
        for (int i = start; i < expression.length(); ++i) {
            if (expression.charAt(i) == '(') {
                ++count;
                continue;
            }
            if (expression.charAt(i) != ')' || --count != 0) continue;
            return i;
        }
        return count == 0 ? expression.length() - 1 : -1;
    }

    private static String transformTrigo(String expression, String fun) throws Exception {
        if (precision) {
            while (expression.contains("sin") || expression.contains("cos") || expression.contains("tan")) {
                int bracketEnd;
                int startCos = expression.indexOf("cos");
                int startSin = expression.indexOf("sin");
                int startTan = expression.indexOf("tan");
                if (startCos != -1 && (startSin != -1 && startTan != -1 && startCos < startTan && startCos < startSin || startSin != -1 && startTan == -1 && startCos < startSin || startSin == -1 && startTan != -1 && startCos < startTan || startTan == -1 && startSin == -1)) {
                    bracketEnd = MathParser.findAdequateBracketEnd(expression, startCos + 3);
                    expression = expression.substring(0, startCos) + MathParser.transformTrigo(expression.substring(startCos + 3, bracketEnd + 1), "cos") + expression.substring(bracketEnd + 1);
                    continue;
                }
                if (startSin != -1 && (startCos != -1 && startTan != -1 && startSin < startTan && startSin < startCos || startCos != -1 && startTan == -1 && startSin < startCos || startCos == -1 && startTan != -1 && startSin < startTan || startCos == -1 && startTan == -1)) {
                    bracketEnd = MathParser.findAdequateBracketEnd(expression, startSin + 3);
                    expression = expression.substring(0, startSin) + MathParser.transformTrigo(expression.substring(startSin + 3, bracketEnd + 1), "sin") + expression.substring(bracketEnd + 1);
                    continue;
                }
                if (startTan == -1 || !(startSin != -1 && startCos != -1 && startTan < startSin && startTan < startCos || startSin != -1 && startCos == -1 && startTan < startSin || startSin == -1 && startCos != -1 && startTan < startCos) && (startCos != -1 || startSin != -1)) continue;
                bracketEnd = MathParser.findAdequateBracketEnd(expression, startTan + 3);
                expression = expression.substring(0, startTan) + MathParser.transformTrigo(expression.substring(startTan + 3, bracketEnd + 1), "tan") + expression.substring(bracketEnd + 1);
            }
            if (fun.equals("sin")) {
                expression = RAD ? MathParser.transformMinus("(" + Math.sin(Math.toRadians(MathParser.calculatePostFix(MathParser.generatePostFix(expression)))) + ")") : (DEG ? MathParser.transformMinus("(" + Math.sin(Math.toDegrees(MathParser.calculatePostFix(MathParser.generatePostFix(expression)))) + ")") : MathParser.transformMinus("(" + Math.sin(MathParser.calculatePostFix(MathParser.generatePostFix(expression))) + ")"));
            } else if (fun.equals("cos")) {
                expression = RAD ? MathParser.transformMinus("(" + Math.cos(Math.toRadians(MathParser.calculatePostFix(MathParser.generatePostFix(expression)))) + ")") : (DEG ? MathParser.transformMinus("(" + Math.cos(Math.toDegrees(MathParser.calculatePostFix(MathParser.generatePostFix(expression)))) + ")") : MathParser.transformMinus("(" + Math.cos(MathParser.calculatePostFix(MathParser.generatePostFix(expression))) + ")"));
            } else if (fun.equals("tan")) {
                expression = RAD ? MathParser.transformMinus("(" + Math.tan(Math.toRadians(MathParser.calculatePostFix(MathParser.generatePostFix(expression)))) + ")") : (DEG ? MathParser.transformMinus("(" + Math.tan(Math.toDegrees(MathParser.calculatePostFix(MathParser.generatePostFix(expression)))) + ")") : MathParser.transformMinus("(" + Math.tan(MathParser.calculatePostFix(MathParser.generatePostFix(expression))) + ")"));
            }
        }
        return expression;
    }

    private static String transformSqr(String expression) {
        if (precision) {
            int pos0 = 0;
            int pos1 = 0;
            while (expression.contains("sqr")) {
                pos0 = expression.indexOf("sqr");
                pos1 = MathParser.findAdequateBracketEnd(expression, pos0 + 3);
                expression = expression.substring(0, pos0) + expression.substring(pos0 + 3, pos1 + 1) + "^2" + expression.substring(pos1 + 1);
            }
        }
        return expression;
    }

    private static String transformExp(String expression) {
        if (precision) {
            expression = expression.replace("e", "2.718281828459045");
        }
        return expression;
    }

    private static String transformPi(String expression) {
        expression = expression.replace("pi", "3.141592653589793");
        expression = expression.replace("\u03c0", "3.141592653589793");
        return expression;
    }

    private static String transformSqrt(String expression) {
        int pos0 = 0;
        int pos1 = 0;
        while (expression.contains("sqrt")) {
            pos0 = expression.indexOf("sqrt");
            pos1 = MathParser.findAdequateBracketEnd(expression, pos0 + 4);
            expression = expression.substring(0, pos0) + expression.substring(pos0 + 4, pos1 + 1) + "^0.5" + expression.substring(pos1 + 1);
        }
        return expression;
    }

    private static String transformMinus(String expression) {
        int pos0 = 0;
        for (int i = 0; i < expression.length(); ++i) {
            if (expression.charAt(i) == '-' && expression.charAt(i - 1) == '(') {
                pos0 = MathParser.findAdequateBracketEnd(expression, i - 1);
                expression = expression.substring(0, i) + "(0-" + expression.substring(i + 1, pos0) + ")" + expression.substring(pos0);
                continue;
            }
            if (expression.charAt(i) != '-' || expression.charAt(i - 1) != '\u00a1' && expression.charAt(i - 1) != '!' && expression.charAt(i - 1) != '|' && expression.charAt(i - 1) != '+' && expression.charAt(i - 1) != '-' && expression.charAt(i - 1) != '/' && expression.charAt(i - 1) != '*' && expression.charAt(i - 1) != '^') continue;
            for (int j = i + 1; j < expression.length(); ++j) {
                if (j != expression.length() - 1 && expression.charAt(j) != '/' && expression.charAt(j) != '*' && expression.charAt(j) != '+' && expression.charAt(j) != '\u00a1' && expression.charAt(j) != '!' && expression.charAt(j) != '|' && expression.charAt(j) != '-' && expression.charAt(j) != '^' && expression.charAt(j) != ')') continue;
                if (j == expression.length() - 1) {
                    pos0 = j + 1;
                    break;
                }
                pos0 = j;
                break;
            }
            expression = expression.substring(0, i) + "(0-" + expression.substring(i + 1, pos0) + ")" + expression.substring(pos0);
        }
        return expression;
    }

    public static Stack<String> generatePostFix(String expression) throws Exception {
        Stack<String> operandStack = new Stack<String>();
        Stack<String> operatorStack = new Stack<String>();
        String number = "";
        int i = 0;
        operatorStack.push("(");
        try {
            while (!operatorStack.isEmpty()) {
                String operator;
                switch (expression.charAt(i)) {
                    case '(': {
                        operatorStack.push("(");
                        break;
                    }
                    case '^': {
                        operatorStack.push("^");
                        break;
                    }
                    case '|': {
                        operatorStack.push("|");
                        break;
                    }
                    case '!': {
                        operatorStack.push("!");
                        break;
                    }
                    case '\u00a1': {
                        operatorStack.push("\u00a1");
                        break;
                    }
                    case '*': {
                        if (precision && ((String)operatorStack.peek()).matches("[^*/]")) {
                            while (!((String)operatorStack.peek()).equals("(") && ((String)operatorStack.peek()).matches("[^*/]")) {
                                operandStack.push((String)operatorStack.pop() + "");
                            }
                        } else if (!precision) {
                            while (!((String)operatorStack.peek()).equals("(")) {
                                operandStack.push((String)operatorStack.pop() + "");
                            }
                        }
                        operatorStack.push("*");
                        break;
                    }
                    case '/': {
                        if (precision && ((String)operatorStack.peek()).matches("[^*/]")) {
                            while (!((String)operatorStack.peek()).equals("(") && ((String)operatorStack.peek()).matches("[^*/]")) {
                                operandStack.push((String)operatorStack.pop() + "");
                            }
                        } else if (!precision) {
                            while (!((String)operatorStack.peek()).equals("(")) {
                                operandStack.push((String)operatorStack.pop() + "");
                            }
                        }
                        operatorStack.push("/");
                        break;
                    }
                    case '-': {
                        while (!((String)operatorStack.peek()).equals("(")) {
                            operandStack.push((String)operatorStack.pop() + "");
                        }
                        operatorStack.push("-");
                        break;
                    }
                    case '+': {
                        while (!((String)operatorStack.peek()).equals("(")) {
                            operandStack.push((String)operatorStack.pop() + "");
                        }
                        operatorStack.push("+");
                        break;
                    }
                    case ')': {
                        operator = "";
                        while (!(operator = (String)operatorStack.pop()).equals("(")) {
                            operandStack.push(operator + "");
                        }
                        break;
                    }
                    default: {
                        number = number + expression.charAt(i) + "";
                        if (i + 1 != expression.length() && expression.charAt(i + 1) != '+' && expression.charAt(i + 1) != '\u00a1' && expression.charAt(i + 1) != '!' && expression.charAt(i + 1) != '|' && expression.charAt(i + 1) != '-' && expression.charAt(i + 1) != '*' && expression.charAt(i + 1) != '/' && expression.charAt(i + 1) != '^' && expression.charAt(i + 1) != ')') break;
                        number = MathParser.check(number);
                        operandStack.push(number);
                        number = "";
                    }
                }
                if (++i != expression.length()) continue;
                operator = "";
                while (!(operator = (String)operatorStack.pop()).equals("(")) {
                    operandStack.push(operator + "");
                }
            }
            return operandStack;
        }
        catch (Exception e) {
            throw new Exception("wrong input");
        }
    }

    public static String check(String toCheck) {
        int val;
        boolean rint = false;
        if (toCheck.contains("DELTA")) {
            rint = true;
            System.out.println("input:" + toCheck);
        }
        if (!toCheck.startsWith("\"") || toCheck.endsWith("\"")) {
            // empty if block
        }
        toCheck = Z80Assembler.setLabels(toCheck);
        toCheck = Z80Assembler.putEQU(toCheck);
        if ((toCheck = MathParser.Format(toCheck)).contains("IX")) {
            toCheck = toCheck.replace("IX", "0");
        }
        if (toCheck.contains("IY")) {
            toCheck = toCheck.replace("IY", "0");
        }
        toCheck = toCheck.replace("#", "&");
        if ((toCheck = toCheck.replace("$", "&")).startsWith("-")) {
            System.out.println("Mathparser: minus found!");
        }
        if (toCheck.startsWith("%")) {
            toCheck = toCheck.substring(1);
            val = Integer.parseInt(toCheck, 2);
            toCheck = "" + val;
        }
        if (toCheck.startsWith("&X")) {
            toCheck = toCheck.substring(2);
            val = Integer.parseInt(toCheck, 2);
            toCheck = "" + val;
        }
        if (toCheck.startsWith("&")) {
            try {
                toCheck = "" + MathParser.hexValue(toCheck.replace("&", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rint) {
            System.out.println("output:" + toCheck);
        }
        return toCheck;
    }

    public static int hexValue(String source) throws Exception {
        int result = 0;
        source = source.trim();
        for (int i = 0; i < source.length(); ++i) {
            byte val = MathParser.hexValue(source.charAt(i));
            if (val < 0 || val > 15) {
                throw new Exception("Illegal hex character in " + source);
            }
            result = (result << 4) + val;
        }
        return result;
    }

    public static byte hexValue(char value) {
        if (value >= 'a') {
            return (byte)(value - 97 + 10);
        }
        if (value > '9') {
            return (byte)(value - 65 + 10);
        }
        return (byte)(value - 48);
    }

    public static double calculatePostFix(Stack<String> operandStack) throws Exception {
        Stack<String> stack = new Stack<String>();
        double result = 0.0;
        stack.addAll(operandStack);
        operandStack.clear();
        while (!stack.isEmpty()) {
            operandStack.add((String)stack.pop());
        }
        try {
            if (operandStack.size() < 3) {
                return Double.parseDouble(operandStack.peek());
            }
            while (!operandStack.isEmpty()) {
                if (!operandStack.peek().matches("[+-/*^|\u00a1!]")) {
                    stack.push(operandStack.pop());
                    continue;
                }
                char operator = operandStack.pop().charAt(0);
                String buffer = (String)stack.pop();
                switch (operator) {
                    case '|': {
                        result = (int)Double.parseDouble((String)stack.pop()) & (int)Double.parseDouble(buffer);
                        stack.push(result + "");
                        break;
                    }
                    case '!': {
                        result = (int)Double.parseDouble((String)stack.pop()) ^ (int)Double.parseDouble(buffer);
                        stack.push(result + "");
                        break;
                    }
                    case '\u00a1': {
                        result = (int)Double.parseDouble((String)stack.pop()) | (int)Double.parseDouble(buffer);
                        stack.push(result + "");
                        break;
                    }
                    case '+': {
                        result = Double.parseDouble((String)stack.pop()) + Double.parseDouble(buffer);
                        stack.push(result + "");
                        break;
                    }
                    case '-': {
                        result = Double.parseDouble((String)stack.pop()) - Double.parseDouble(buffer);
                        stack.push(result + "");
                        break;
                    }
                    case '*': {
                        result = Double.parseDouble((String)stack.pop()) * Double.parseDouble(buffer);
                        stack.push(result + "");
                        break;
                    }
                    case '/': {
                        result = Double.parseDouble((String)stack.pop()) / Double.parseDouble(buffer);
                        stack.push(result + "");
                        break;
                    }
                    case '^': {
                        double a = Double.parseDouble((String)stack.pop());
                        result = Math.pow(a, Double.parseDouble(buffer));
                        stack.push(result + "");
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new Exception("Wrong input");
        }
    }

    private static double getResult() {
        return result;
    }

    public static void main(String[] argv) {
        if (argv.length < 1 || argv[0].length() == 0) {
            String usage = "Usage: java Parser equation\nYou can set deg: rad: grad:\nExample: 'rad:2^sin(5^(3+5))'";
            System.err.println(usage);
        } else {
            try {
                String g = argv[0];
                g = MathParser.parseMaths(g);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        precision = false;
    }
}

